;; V_cus.lsp -- settings file
;------------------------- CUSTOM OBJECTS --------------------------------
; NOTES:  Object definitions consist of 6 lines. The 1st and last are
; codes, and the 5th line is optional and may be blank.  Definitions (units 
; of 6-lines) may by inserted or deleted from the objects list.  When
; lines have two values, they must be separated with a minimum of 1 space.
; (Characters following ";" are comments)
;   Difinition items ***************************************************
;     DEFINITION: (in quotes): name for dialog box (displays max 40-char.
;     LAYER NAME: (in quotes): layer name ("" = use current)
;     COLOR#: (in quotes): layer color if created ("" = use current)
;     LINETYPE: (in quotes): linetype for created layer 
;         ("C" or "" = continuous)
;     OBJECT TYPE: (a key letter in quotes): See object type list.
;     OPTION#1: (w/ no quotes): a decimal number specifing a code or a
;       distance in drawing units (blank line = no options).
;       Enter a negative number (-) and the absolute distance
;       will be converted to plot units.  
;       Numbers between -1 and 1 must begin with 0.  If Option#2 
;       is used, Option#1 must have a value.  Options are specific to 
;       the object type, see object type list.
;     OPTION#2: (no quotes): same as Option#1
;
;   Oject Types *******************************************************
;   KEY   OBJECT-TYPE   OPTION#1               OPTION#2
;    A    Arc           Extrusion distance     -no opt
;    C    Circle        Radius                 Extrusion dist    
;    D    Donut         Inside diameter        Outside diameter
;    E    Ellipse       -no opt                -no opt
;    L    Line          Extrusion distance     -no opt
;    P    Polyline      Polyline width         Spline? 0=no 1=yes
;    R    Rectangle     Width                  Height
;    S    Solid         -no opt                -no opt
;    T    Trace         Trace width            -no opt
;    3    3DFace        -no opt                -no opt
;
; ------------------------------------------------------------------
; If using the extra line type definitions provided,
; the line type names in the following samples may be changed
; to the preferred line as follows:  
;   Property line: propln     Prop line small: propsm    Demo: dash332
;   Exist contour: xcontour   Center/match line: dimcen
;
; Note re: contour example--for splined broken line polylines,
; the AutoCad "plinegen" system variable should be set to 1.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun v_cus () (setq mlst (list  ;;     Begin Master list       ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(list ;; ************ begin object def *****************************
"Property line"               ;; "Descrip of object"
"boundline" "6"               ;; "Layer name"    (space) "color#"
"phantom"  "L"                ;; "linetype-name" (space) "Object-key-letter"
                              ;;  Option#1       (space)  Option#2
) ;; **** end object def *******

(list ;; ************ begin object def *****************************
"Property line -- Small"      ;; "Descrip of object"
"boundsm" "4"                 ;; "Layer name"    (space) "color#"
"phantom2"  "L"               ;; "linetype-name" (space) "Object-key-letter"
                              ;;  Option#1       (space)  Option#2
) ;; end object def ************************************************

(list ;; ************ begin object def *****************************
"Demo line"                   ;; "Descrip of object"
"demo" "5"                    ;; "Layer name"    (space) "color#"
"dashed2"  "L"                ;; "linetype-name" (space) "Object-key-letter"
                              ;;  Option#1       (space)  Option#2
) ;; end object def ************************************************

(list ;; ************ begin object def *****************************
"Existing Contours"           ;; "Descrip of object"
"Xtopo" "5"                   ;; "Layer name"    (space) "color#"
"hiddenx2"  "P"               ;; "linetype-name" (space) "Object-key-letter"
0   1                         ;;  Option#1       (space)  Option#2
) ;; end object def ************************************************

(list ;; ************ begin object def *****************************
"Center/Match line"           ;; "Descrip of object"
"Matchline" "4"               ;; "Layer name"    (space) "color#"
"divide"  "L"                 ;; "linetype-name" (space) "Object-key-letter"
                              ;;  Option#1       (space)  Option#2
) ;; end object def ************************************************

                              ;; insert additional object defs here

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
))(princ))         ;;      End master list             ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
